<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

class AddQrCodeToContactsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->string('qr_code', 64)->nullable()->after('contact_id')->unique();
        });

        DB::table('contacts')
            ->whereNull('qr_code')
            ->orderBy('id')
            ->chunkById(100, function ($contacts) {
                foreach ($contacts as $contact) {
                    DB::table('contacts')
                        ->where('id', $contact->id)
                        ->update(['qr_code' => Str::uuid()->toString()]);
                }
            });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->dropColumn('qr_code');
        });
    }
}
